--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- An ingredient game object.
--- @class tes3ingredient : tes3item, tes3physicalObject, tes3object, tes3baseObject
--- @field effectAttributeIds number[] *Read-only*. An array-style table access the attributes associated with the effects.
--- @field effects tes3.effect[]|integer[] *Read-only*. An array-style table access to the four ingredient effects. Unlike alchemy or enchanting objects, these are simple numbers representing the effect ID (the values map to [`tes3.effect`](https://mwse.github.io/MWSE/references/magic-effects/) table).
--- @field effectSkillIds number[] *Read-only*. An array-style table access the skills associated with the effects.
--- @field script tes3script The script that runs on the object.
--- @field value number The value of the object.
--- @field weight number The weight of the object.
tes3ingredient = {}

--- Gets the first index of an effect ID in the ingredient's effect table. Returns `-1` if provided effect doesn't exist in the ingredient.
--- @param effectId tes3.effect|integer A value from [`tes3.effect`](https://mwse.github.io/MWSE/references/magic-effects/) table.
--- @return integer index Returns 0-based index. Because Lua's arrays are 1-based, to index the ingredient's `effects` array with the return value add 1.
function tes3ingredient:getFirstIndexOfEffect(effectId) end

--- Determines if the ingredient contains an effect with the given id.
--- @param effectId tes3.effect|integer A value from [`tes3.effect`](https://mwse.github.io/MWSE/references/magic-effects/) table.
--- @return boolean hasEffect Returns `true` if the ingredient contains the given effect id, otherwise `false`.
function tes3ingredient:hasEffect(effectId) end

